/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.drools.process.core.ParameterDefinition;
import org.drools.process.core.Work;
import org.drools.process.core.datatype.DataType;
import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.compiler.xml.XmlWorkflowProcessDumper;
import org.jbpm.compiler.xml.processes.AbstractNodeHandler;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemNodeHandler
extends AbstractNodeHandler {
    @Override
    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        WorkItemNode workItemNode = (WorkItemNode)node;
        String waitForCompletion = element.getAttribute("waitForCompletion");
        workItemNode.setWaitForCompletion(!"false".equals(waitForCompletion));
        for (String eventType : workItemNode.getActionTypes()) {
            this.handleAction(workItemNode, element, eventType);
        }
    }

    @Override
    protected Node createNode() {
        return new WorkItemNode();
    }

    @Override
    public Class<?> generateNodeFor() {
        return WorkItemNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        WorkItemNode workItemNode = (WorkItemNode)node;
        this.writeNode("workItem", workItemNode, xmlDump, includeMeta);
        this.visitParameters(workItemNode, xmlDump);
        xmlDump.append(">" + EOL);
        if (includeMeta) {
            this.writeMetaData(workItemNode, xmlDump);
        }
        Work work = workItemNode.getWork();
        this.visitWork(work, xmlDump, includeMeta);
        this.visitInMappings(workItemNode.getInMappings(), xmlDump);
        this.visitOutMappings(workItemNode.getOutMappings(), xmlDump);
        for (String eventType : workItemNode.getActionTypes()) {
            this.writeActions(eventType, workItemNode.getActions(eventType), xmlDump);
        }
        this.writeTimers(workItemNode.getTimers(), xmlDump);
        this.endNode("workItem", xmlDump);
    }

    protected void visitParameters(WorkItemNode workItemNode, StringBuilder xmlDump) {
        if (!workItemNode.isWaitForCompletion()) {
            xmlDump.append("waitForCompletion=\"false\" ");
        }
    }

    protected void visitInMappings(Map<String, String> inMappings, StringBuilder xmlDump) {
        for (Map.Entry<String, String> inMapping : inMappings.entrySet()) {
            xmlDump.append("      <mapping type=\"in\" from=\"" + inMapping.getValue() + "\" " + "to=\"" + inMapping.getKey() + "\" />" + EOL);
        }
    }

    protected void visitOutMappings(Map<String, String> outMappings, StringBuilder xmlDump) {
        for (Map.Entry<String, String> outMapping : outMappings.entrySet()) {
            xmlDump.append("      <mapping type=\"out\" from=\"" + outMapping.getKey() + "\" " + "to=\"" + outMapping.getValue() + "\" />" + EOL);
        }
    }

    protected void visitWork(Work work, StringBuilder xmlDump, boolean includeMeta) {
        if (work != null) {
            xmlDump.append("      <work name=\"" + work.getName() + "\" >" + EOL);
            ArrayList<ParameterDefinition> parameterDefinitions = new ArrayList<ParameterDefinition>(work.getParameterDefinitions());
            Collections.sort(parameterDefinitions, new Comparator<ParameterDefinition>(){

                @Override
                public int compare(ParameterDefinition o1, ParameterDefinition o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (ParameterDefinition paramDefinition : parameterDefinitions) {
                DataType dataType = paramDefinition.getType();
                xmlDump.append("        <parameter name=\"" + paramDefinition.getName() + "\" >" + EOL + "  ");
                XmlWorkflowProcessDumper.visitDataType(dataType, xmlDump);
                Object value = work.getParameter(paramDefinition.getName());
                if (value != null) {
                    xmlDump.append("  ");
                    XmlWorkflowProcessDumper.visitValue(value, dataType, xmlDump);
                }
                xmlDump.append("        </parameter>" + EOL);
            }
            xmlDump.append("      </work>" + EOL);
        }
    }
}

